// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Karte.h
//
//	created November 4th,97 by Andreas Warnke
//	geändert 28.12.97 von Andreas Warnke
//



#ifndef Karte_h_
#define Karte_h_



// // // // // // // // // // // // // // // //
//
//	Karte
//

class Karte
{
private:	
	//	SpielFeld:
	//	Anordnung der Felder:
	//	
	//	0	  [ ] [ ] [2] [3] [4] [5] [6] [ ] [ ]
	//	1	[ ] [ ] [2] [3] [4] [5] [6] [7] [ ]
	//	2	  [ ] [1] [2] [3] [4] [5] [6] [7] [ ]
	//	3	[ ] [1] [2] [3] [4] [5] [6] [7] [8] 
	//	4	  [0] [1] [2] [3] [4] [5] [6] [7] [8]
	//	5	[ ] [1] [2] [3] [4] [5] [6] [7] [8]
	//	6	  [ ] [1] [2] [3] [4] [5] [6] [7] [ ]
	//	7	[ ] [ ] [2] [3] [4] [5] [6] [7] [ ]
	//	8	  [ ] [ ] [2] [3] [4] [5] [6] [ ] [ ]
	uint8 *Feld;
	
protected:
	//	interne Feldgröße
	int Width, Height;
	
public:
	
	//	Konstruktor, initialisiert Karte mit 0 und 1 Feldern
	Karte ( int inSize = 10 );
	
	//	Destruktor:
	virtual ~Karte ();
	
	//	Feld in/out
	uint8 GetFieldType ( int x, int y );
	bigtime_t GetFieldDelay ( int x, int y );
	static inline bigtime_t GetFieldDelay ( int inType );
	void SetFieldType ( int x, int y , uint8 NewValue );
	static inline int GetFieldViewCost ( int inType );
	int GetFieldViewCost ( int x, int y );
	
	//	Kartengröße:
	int GetWidth ();
	int GetHeight ();
	//	IsShiftRight liefert 1, wenn die Zeile nach rechts, bzw.
	//	0, wenn die Zeile nach links versetzt ist.
	static inline int IsShiftRight ( int inRow );
	//	Bestimmen der Entfernung zweier Felder:
	static unsigned int Distance ( int inX1, int inY1, int inX2, int inY2); 
};



// // // // // // // // // // // // // // // //
//
//	FieldTypes AND FieldDelays AND FieldViewCosts AND FieldImages
//	The FieldDelays says, how many microseconds are needed for one step.
//	Every FieldDelays is equal or greater than FD_Minimum 
//	The FieldViewCost says, how far you can see.
//	1 = far, 2 = average, 3 = only near
//	FieldImages ist the number of equal FieldTypes
//

//	Minimales Delay für Entfernungs-Heuristiken (1 sec):
#define FD_Minimum 1000000
#define FD_Heuristik ( 2 * FD_Minimum )
//	Maximale Verzoegerung durch Server-Client-Kommunikation
/*#define FD_Communication 1850000*/
#define FD_Communication 50000000
//	Unendlich (1 h):
#define FD_NoWay 3600000000
//	Zeit, um Dorf zu bauen:
#define FD_BuildVillage 0
#define FD_CreateArmy ( 256 * FD_Minimum )
/*#define FD_CreateArmy ( 5 * FD_Minimum )*/

//	Maximale Sichtweite:
#define FV_Far 1
//	Minimale Sichtweite:
#define FV_Near 3
//	Mittlere Sichtweite:
#define FV_Average 2

//	Steuerzeichen 0x00 - 0x0f
#define FT_EndOfWorld 0x00
#define FD_EndOfWorld FD_NoWay
#define FV_EndOfWorld FV_Near
#define FT_Invisible 0x08
#define FD_Invisible FD_Minimum	//	?? sollte nicht gebraucht werden.
#define FV_Invisible FV_Near

//	not used by Server: 0x10 - 0x1f
#define FT_Undiscovered 0x10
#define FD_Undiscovered ( 2 * FD_Minimum ) 
#define FV_Undiscovered FV_Near
#define FI_Undiscovered 1
#define FT_HighlightWabe 0x18

//	Barrieren 0x20 - 0x3f
#define FT_Sea 0x20
#define FD_Sea FD_NoWay
#define FV_Sea FV_Far
#define FI_Sea 4

//	Normales Gelände 0x40 - 0x7f
#define FT_Plain 0x40
#define FD_Plain ( 2* FD_Minimum )
#define FV_Plain FV_Far
#define FI_Plain 4
#define FT_Forrest 0x50	
#define FD_Forrest ( 5 * FD_Minimum )
#define FV_Forrest FV_Near
#define FI_Forrest 4
#define FT_Mountain 0x60	
#define FD_Mountain ( 9 * FD_Minimum )
#define FV_Mountain FV_Average
#define FI_Mountain 4

//	not used by Server: 0x80 - 0xff
//	Masken für FeldTypen:
#define FT_TypeMask 0x7f
//	Invisible-Bit:
#define FT_ShadowMask 0x80



#endif



//
//	Ende.
//
// // // // // // // // // // // // // // // //